#pragma once
#include <render/integrator.h>
#include "boundary_unidir.h"
#include "boundary_bidir.h"

struct BoundaryMIS : Integrator, MISIntegrator {
    BoundaryMIS(const Properties &props);
    void configure(const Scene &scene) override;
    // forward rendering
    ArrayXd renderC(const Scene &scene, const RenderOptions &options) const override;
    // rendering gradient image
    ArrayXd renderD(SceneAD &sceneAD, const RenderOptions &options, const ArrayXd &d_image) const override;

    BoundaryUnidirectional boundaryUnidirectional;
    BoundaryBidirectional boundaryBidirectional;
};