#include "interior.h"
#include "../volpathBase.h"
#include <render/scene.h>
#include <algorithm1.h>

Spectrum VolpathInterior::Li(const Scene &scene, const Ray &ray, RadianceQueryRecord &rRec) const
{
    Spectrum ret = volpath_base::__Li(scene, ray, rRec, nullptr);
    if(!ret.allFinite())
        PSDR_WARN("VolpathInterior::Li: NaN encountered");
    return ret;
}

void VolpathInterior::LiAD(SceneAD &sceneAD, const Ray &ray, RadianceQueryRecord &rRec, const Spectrum &d_res) const
{
    sceneAD.val.state.use_tetmesh = false;
    LightPath path;
    Spectrum value = volpath_base::__Li(sceneAD.val, ray, rRec, &path);
    if (value.isZero(Epsilon))
        return;
    if (!value.allFinite())
        PSDR_WARN("VolpathInterior::Li: NaN encountered");
    LightPathAD pathAD(path);
    algorithm1_vol::d_eval(sceneAD.val, sceneAD.getDer(), pathAD, d_res, rRec.sampler);
}