#include "volpath2.h"
#include <render/scene.h>

ArrayXd Volpath2::renderC(const Scene &scene, const RenderOptions &options) const
{
    return volpathInterior.renderC(scene, options);
}

ArrayXd Volpath2::renderD(SceneAD &sceneAD, const RenderOptions &options, const ArrayXd &d_image) const
{
    sceneAD.val.state.use_tetmesh = false;
    return volpathInterior.renderD(sceneAD, options, d_image) +
           volpathBoundary.renderD(sceneAD, options, d_image);
}
