#pragma once
#include <render/integrator.h>
#include "interior.h"
#include "boundary_unidir.h"
struct RndSampler;
struct Ray;

struct VolpathMerged : UnidirectionalPathTracer
{
    VolpathMerged(const Properties &props = Properties({ { "enable_antithetic", false } }))
        : UnidirectionalPathTracer(props), volpathInterior(props), volpathBoundary(props) {}
    Spectrum Li(const Scene &scene, const Ray &ray, RadianceQueryRecord &rRec) const override;
    void LiAD(SceneAD &sceneAD, const Ray &ray, RadianceQueryRecord &rRec, const Spectrum &d_res) const override;

    std::string getName() const override { return "Volpath Merged"; }
    VolpathInterior volpathInterior;
    BoundaryUnidirectional volpathBoundary;
};