#pragma once
#include <render/integrator.h>

struct RndSampler;
struct Ray;
struct SceneAD;

struct Path2 : UnidirectionalPathTracer
{
    Path2(const Properties &props = Properties({ { "enable_antithetic", true } }))
        : UnidirectionalPathTracer(props) {}
    Spectrum Li(const Scene &scene, const Ray &ray, RadianceQueryRecord &rRec) const override;
    void LiAD(SceneAD &sceneAD, const Ray &ray, RadianceQueryRecord &rRec, const Spectrum &d_res) const override;

    std::string getName() const override { return "Path2"; }

    ArrayXd renderD(SceneAD &sceneAD, const RenderOptions &options, const ArrayXd &__d_image) const override;
    ArrayXd forwardRenderD(SceneAD &sceneAD, const RenderOptions &options) const;
    Spectrum LiFwd(SceneAD &sceneAD, const Ray &ray, RadianceQueryRecord &rRec) const override;
};


void d_configure_shape(Shape *shape, Shape *d_shape);