#pragma once
#include <render/integrator.h>
#include <render/camera.h>
#include <render/imageblock.h>
#include <core/logger.h>
struct RndSampler;
struct Ray;
struct LightPath;

// camera agnostic
struct ParticleTracerBase
{
    // just like Li
    void importance(const Scene &scene, RndSampler *sampler,
                    const Medium *medium, const Ray &ray, bool on_surface,
                    int depth, int max_bounces,
                    const Spectrum &throughput);

    // sample a particle on the emitters
    std::tuple<Spectrum, Intersection> sampleParticle(const Scene &scene, RndSampler *sampler);

    // sample and trace the particle
    void traceParticle(const Scene &scene, RndSampler *sampler, int max_bounces);

    void handleEmission(const Scene &scene, RndSampler *sampler,
                        const Intersection &its, const Spectrum &throughput);

    // connect to the camera from medium event
    virtual void handleMedium(const Scene &scene, RndSampler *sampler,
                              const Medium *medium, const Vector &p, 
                              const Vector &wi, const Vector &wo,
                              int depth, const Spectrum &throughput);

    // no phase function handling, used for medium boundary term
    virtual void handleMedium(const Scene &scene, RndSampler *sampler,
                              const Medium *medium, const Vector &p,
                              int depth, const Spectrum &throughput);

    virtual void handleSurface(const Scene &scene, RndSampler *sampler,
                               const Intersection &its,
                               int depth, const Spectrum &throughput);

    // handle the camera filter, suppose to be overridden
    // can be used to compute the gradient
    virtual void handleSensor(const Scene &scene, RndSampler *sampler,
                              const CameraDirectSamplingRecord &cRec,
                              int depth, const Spectrum &throughput){};
};

struct ParticleTracer3 : ParticleTracerBase
{
    ParticleTracer3(std::vector<Spectrum> &image) : image(image) {}
    void handleSensor(const Scene &scene, RndSampler *sampler,
                      const CameraDirectSamplingRecord &cRec,
                      int depth, const Spectrum &throughput) override;

    std::vector<Spectrum> &image; // store pixel color to image
};