#pragma once
#include <core/logger.h>
#include <render/camera.h>
#include <render/imageblock.h>
#include <render/integrator.h>
struct RndSampler;
struct Ray;
struct LightPath;

namespace volpath_base {
Spectrum __Li(const Scene &scene, const Ray &_ray, const RadianceQueryRecord &rRec, LightPath *path);
}

struct VolpathBase : public MISIntegrator {
    VolpathBase() = default;
    VolpathBase(ESamplingMode mode) : MISIntegrator(mode) {}
    VolpathBase(const Properties &props);

    // radiance of camera ray
    Spectrum Li1(const Scene &scene, RndSampler *sampler,
                 const Medium *medium, const Ray &ray, Array2i pixel_id, int max_bounces, bool incEmission);

    // radiance
    // L(x, w) = \int T(x, x') \sigma_s(x') L(x', w) dt
    Spectrum Li(const Scene &scene, RndSampler *sampler,
                const Medium *medium, const Ray &ray, int max_bounces, bool incEmission);

    // insacttering with wi
    // Lins(x, w) = \int f(x, -w', w) L(w') dw'
    // input : medium, p, wi(optional), max_bounces
    Spectrum Lins(const Scene &scene, RndSampler *sampler,
                  const Medium *medium, const Vector &p, const Vector &wi, int max_bounces);

    // nee: sample emitter from medium event
    // input : medium, p, wi(optional), mis
    Spectrum neeEmitter(const Scene &scene, RndSampler *sampler,
                        const Medium *medium, const Vector &p, const Vector &wi);

    // nee: sample phase function from medium event
    Spectrum neePhase(const Scene &scene, RndSampler *sampler,
                      const Medium *medium, const Vector &p, const Vector &wi);

    // nee: from medium event
    Spectrum nee(const Scene &scene, RndSampler *sampler,
                 const Medium *medium, const Vector &p, const Vector &wi);

    virtual bool isNext(int bounces) const { return true; }
    virtual void handleSensor(const Scene &scene, RndSampler *sampler, const Ray &ray,
                              const Array2i &pixel_idx, const Medium *medium, int max_bounces){};

    // callback
    virtual void handleMedium(const Scene &scene, RndSampler *sampler,
                              const Medium *medium, const Vector &p, 
                              const Vector &wi, const Vector &wo,
                              int max_bounces, const Spectrum &throughput){};

    virtual void handleSurface(const Scene &scene, RndSampler *sampler,
                               const Intersection &its,
                               int max_bounces, const Spectrum &throughput){};

    virtual Spectrum handleNee(const Scene &scene, RndSampler *sampler,
                               const Medium *medium, const Vector &p, const Vector &wi);

    virtual void handleNee(const Spectrum &value){};

    virtual Spectrum handleEmission(const Intersection &its, const Vector &wo, bool incEmission);

    struct Stats {
        int depth;
    };

    std::function<void(const Stats &)> stats_callback;

    void report(const Stats &stats) const {
        if (stats_callback) {
            stats_callback(stats);
        }
    }
};