#include <render/medium.h>

#include "medium/heterogeneous.h"
#include "medium/homogeneous.h"

Float Medium::sigT(const Vector &x) const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "Homogeneous") == 0)
        return static_cast<const Homogeneous *>(this)->sigT(x);
    if (dynamic_cast<const Heterogeneous *>(this))
        return static_cast<const Heterogeneous *>(this)->sigT(x);
    assert(false);
    return 0;
}

PSDR_INACTIVE_CLASS(Medium)

namespace medium {
__attribute__((noinline)) void __sigS(const Medium *medium,
                                      const Vector &x,
                                      Spectrum     &ret) {
    if (medium->m_type == Homogeneous::TYPE_ID) {
        PSDR_INVOKE_MEDIUM_HELPER_SIGS(Homogeneous, medium, x, ret);
    } else if (medium->m_type == Heterogeneous::TYPE_ID) {
        PSDR_INVOKE_MEDIUM_HELPER_SIGS(Heterogeneous, medium, x, ret);
    }
}
// evalTransmittance
__attribute__((noinline)) void __evalTransmittance(const Medium *medium,
                                                   const Ray    &ray,
                                                   const Float  &tmin,
                                                   const Float  &tmax,
                                                   RndSampler   *sampler,
                                                   Float        &ret) {
    if (medium->m_type == Homogeneous::TYPE_ID) {
        PSDR_INVOKE_MEDIUM_HELPER_EVAL_TRANSMITTANCE(Homogeneous, medium, ray, tmin, tmax, sampler, ret);
    } else if (medium->m_type == Heterogeneous::TYPE_ID) {
        PSDR_INVOKE_MEDIUM_HELPER_EVAL_TRANSMITTANCE(Heterogeneous, medium, ray, tmin, tmax, sampler, ret);
    }
}
// evalTransmittanceRatio
__attribute__((noinline)) void __evalTransmittanceRatio(const Medium *medium,
                                                        const Ray    &ray,
                                                        const Float  &tmin,
                                                        const Float  &tmax,
                                                        RndSampler   *sampler,
                                                        Float        &ret) {
    if (medium->m_type == Homogeneous::TYPE_ID) {
        PSDR_INVOKE_MEDIUM_HELPER_EVAL_TRANSMITTANCE_RATIO(Homogeneous, medium, ray, tmin, tmax, sampler, ret);
    } else if (medium->m_type == Heterogeneous::TYPE_ID) {
        PSDR_INVOKE_MEDIUM_HELPER_EVAL_TRANSMITTANCE_RATIO(Heterogeneous, medium, ray, tmin, tmax, sampler, ret);
    }
}

} // namespace medium

Spectrum Medium::sigS(const Vector &x) const {
    // call stub
    Spectrum ret;
    medium::__sigS(this, x, ret);
    return ret;
}

Float Medium::evalTransmittance(const Ray &ray, const Float &tmin,
                                const Float &tmax, RndSampler *sampler) const {
    Float ret;
    medium::__evalTransmittance(this, ray, tmin, tmax, sampler, ret);
    return ret;
}

Float Medium::evalTransmittanceRatio(const Ray &ray, const Float &tmin,
                                     const Float &tmax, RndSampler *sampler) const {
    Float ret;
    medium::__evalTransmittanceRatio(this, ray, tmin, tmax, sampler, ret);
    return ret;
}