#include <render/phase.h>

Float PhaseFunction::sample(const Vector &wi, const Vector2 &rnd2, Vector &wo) const {
    if (m_type == HGPhaseFunction::TYPE_ID) {
        return static_cast<const HGPhaseFunction *>(this)->sample(wi, rnd2, wo);
    } else if (m_type == IsotropicPhaseFunction::TYPE_ID) {
        return static_cast<const IsotropicPhaseFunction *>(this)->sample(wi, rnd2, wo);
    }
    assert(false);
    return 0;
}
Float PhaseFunction::pdf(const Vector &wi, const Vector &wo) const {
    if (m_type == HGPhaseFunction::TYPE_ID) {
        return static_cast<const HGPhaseFunction *>(this)->pdf(wi, wo);
    } else if (m_type == IsotropicPhaseFunction::TYPE_ID) {
        return static_cast<const IsotropicPhaseFunction *>(this)->pdf(wi, wo);
    }
    assert(false);
    return 0;
}
Float PhaseFunction::eval(const Vector &wi, const Vector &wo) const {
    if (m_type == HGPhaseFunction::TYPE_ID) {
        return static_cast<const HGPhaseFunction *>(this)->eval(wi, wo);
    } else if (m_type == IsotropicPhaseFunction::TYPE_ID) {
        return static_cast<const IsotropicPhaseFunction *>(this)->eval(wi, wo);
    }
    assert(false);
    return 0;
}

PSDR_INACTIVE_CLASS(PhaseFunction)
INACTIVE_FN(PhaseFunction_pdf, &PhaseFunction::pdf);
INACTIVE_FN(PhaseFunction_sample, &PhaseFunction::sample);