#include <catch2/catch.hpp>
#include <tiny_obj_loader.h>
#include <iostream>
#include <sstream>
namespace
{
    std::string obj = R"(
####
#
# OBJ File Generated by Meshlab
#
####
# Object cbox_largebox.obj
#
# Vertices: 8
# Faces: 12
#
####
v 423.000000 330.000000 247.000000
v 265.000000 330.000000 296.000000
v 314.000000 330.000000 456.000000
v 472.000000 330.000000 406.000000
v 423.000000 0.000000 247.000000
v 472.000000 0.000000 406.000000
v 314.000000 0.000000 456.000000
v 265.000000 0.000000 296.000000
# 8 vertices, 0 vertices normals

f 1 2 3
f 1 3 4
f 5 1 4
f 5 4 6
f 6 4 3
f 6 3 7
f 7 3 2
f 7 2 8
f 8 2 1
f 8 1 5
f 6 7 8
f 6 8 5
# 12 faces, 0 coords texture

# End of File
    )";
} // namespace

TEST_CASE("shape", "[core]")
{
    tinyobj::attrib_t attrib;
    std::vector<tinyobj::shape_t> shapes;
    std::vector<tinyobj::material_t> materials;
    std::string warn, err;
    std::string filename = "/home/javis/Documents/MyProjects/psdr_enzyme/tests/cbox/meshes/largebox.obj";
    std::istringstream iss(obj);
    bool ret = tinyobj::LoadObj(&attrib, &shapes, &materials, &warn, &err, &iss);
    if (!ret)
    {
        std::cout << "warn: " << warn << std::endl;
        std::cout << "err: " << err << std::endl;
    }
    REQUIRE(ret);

    std::cout << "num_shape: " << shapes.size() << std::endl;
    std::cout << "num_material: " << materials.size() << std::endl;
    std::cout << std::endl;
    int num_vertices = attrib.vertices.size() / 3;
    for (int i = 0; i < num_vertices; i++)
    {
        std::cout << "v: "
                  << attrib.vertices[i * 3] << " "
                  << attrib.vertices[i * 3 + 1] << " "
                  << attrib.vertices[i * 3 + 2] << std::endl;
    }

    tinyobj::shape_t shape = shapes[0];
    std::cout << "num_face: " << shape.mesh.num_face_vertices.size() << std::endl;
    for (int i = 0; i < shape.mesh.num_face_vertices.size(); i++)
    {
        assert(shape.mesh.num_face_vertices[i] == 3);
        std::cout << "f: "
                  << shape.mesh.indices[i * 3].vertex_index << " "
                  << shape.mesh.indices[i * 3 + 1].vertex_index << " "
                  << shape.mesh.indices[i * 3 + 2].vertex_index << std::endl;
    }
}