#include <catch2/catch.hpp>
#include <fwd.h>
#include <transform.h>
#include <iostream>
using namespace psdr::transform;
TEST_CASE("Translate", "[core]")
{
    Eigen::Affine3d transform(Eigen::Translation3d(1, 2, 3));
    Matrix4x4 matrix = transform.matrix();
    std::cout << matrix << std::endl;
}

TEST_CASE("Perspective", "[core]")
{
    Matrix4x4 matrix = perspective(45.f, 1.f, 10.f);
    std::cout << matrix << std::endl;
}

TEST_CASE("LookAt", "[core]")
{
    Matrix4x4 matrix = look_at(Vector(0, 0, 0), Vector(1, 0, 0), Vector(0, 1, 0));
    std::cout << matrix << std::endl;
}

TEST_CASE("Reshape", "[core]")
{
    Eigen::Matrix<Float, 16, 1> matrix;
    matrix << 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16;
    std::cout << Matrix4x4(matrix.data()) << std::endl;
    std::cout << Matrix4x4(matrix.data()).transpose() << std::endl;
}

TEST_CASE("Scale", "[core]")
{
    Vector v(1, 2, 3);
    Matrix3x3 m = Eigen::Scaling(v.x(), v.y(), v.z());
    std::cout << m << std::endl;

    Matrix4x4 m4 = scale(v);
    std::cout << m4 << std::endl;
}