import pytest
import torch
import numpy as np
import psdr_cpu as psdr
from pypsdr.utils.io import mkdir
from pypsdr.validate import RenderOptions
import pypsdr
import os

file = "/home/zih/Projects/psdr-enzyme/data/scenes/volcube/scene.xml"
out_dir = "./out"


@pytest.fixture
def set_xform(sceneAD):
    scene = sceneAD.val
    shape = scene.shapes[0]
    shape.requires_grad = True
    shape.setTranslation([1., 0., 0.])
    

@pytest.fixture
def d_image(height, width):
    d_image = np.ones((height, width, 3))
    d_image[:, :, 1:3] = 0
    d_image = d_image.reshape(-1)
    return d_image


@pytest.fixture
def options():
    return RenderOptions(0, 1, 100, 0, 0, 0, 0)


def imwrite(img, filename):
    mkdir(out_dir)
    pypsdr.utils.io.imwrite(img, os.path.join(out_dir, filename))
