import numpy as np
# import torch
import psdr_cpu as psdr
from pypsdr.utils.io import imwrite
from pypsdr.validate import RenderOptions, Scene
psdr.set_verbose(True)
file = "/home/zih/Projects/psdr-enzyme/data/scenes/volcube/scene.xml"
integrator = psdr.Volpath()
scene = Scene(file)
shape = scene.shapes[0]
shape.requires_grad = True
shape.setTranslation([1., 0., 0.])
sceneAD = psdr.SceneAD(scene)
options = RenderOptions(0, 1, 1000, 0, 0, 0, 0)
height, width = scene.camera.getCropSize()
d_image = np.ones((height, width, 3))
d_image[:, :, 1:3] = 0
d_image = d_image.reshape(-1)
grad_image = integrator.renderD(sceneAD, options, d_image)
grad_image = grad_image.reshape(height, width, 3)
imwrite(grad_image, "backward.exr")
# img = torch.tensor(grad_image)
# img[img.isnan()] = 0
# img = img.reshape((height, width, 3))
# imwrite(img.numpy(), "backward.exr")
# print("finished")