import pytest
import torch
import numpy as np
import psdr_cpu as psdr
from tests.psdr import *
from tests.integrator.config import *
from pypsdr.utils.io import mkdir
from pypsdr.validate import RenderOptions
import pypsdr
import os

file = "../../data/scenes/kitty_in_cbox/scene.xml"
out_dir = "./out"

@pytest.fixture
def options0():
    return RenderOptions(0, 1, 1000, 0, 0, 0, 0)

@pytest.fixture
def options():
    return RenderOptions(0, 5, 0, 0, 1000, 0, 0)


def imwrite(img, filename):
    mkdir(out_dir)
    pypsdr.utils.io.imwrite(img, os.path.join(out_dir, filename))


@pytest.mark.parametrize('file', [file])
def test_renderC(scene, options0, height, width):
    integrator = psdr.Volpath()
    grad_image = integrator.renderC(scene, options0)
    grad_image = grad_image.reshape(height, width, 3)
    imwrite(grad_image, "./image.exr")


@pytest.mark.parametrize('file', [file])
def test_direct_boundary(set_xform, sceneAD, options, d_image, height, width):
    integrator = psdr.VolDirectEdgeIntegrator(sceneAD.val)
    grad_image = integrator.renderD(sceneAD, options, d_image)
    grad_image = grad_image.reshape(height, width, 3)
    imwrite(grad_image, "./grad_image.exr")


if __name__ == "__main__":
    pytest.main(["-x", "./test_direct_boundary.py::test_direct_boundary", "-s"])
