import torch
import pytest
import psdr_cpu as psdr
from pypsdr.validate import *
import os
os.environ['KMP_DUPLICATE_LIB_OK'] = 'True'


psdr.set_verbose(True)


@pytest.fixture
def scene(file):
    return Scene(file)


@pytest.fixture
def camera(scene):
    return scene.camera


@pytest.fixture
def sceneAD(scene):
    sceneAD = psdr.SceneAD(scene)
    return sceneAD


@pytest.fixture
def crop_size(scene):
    return scene.camera.getCropSize()


@pytest.fixture
def height(crop_size):
    return crop_size[0]


@pytest.fixture
def width(crop_size):
    return crop_size[1]
