import psdr_cpu as psdr
import pytest
import numpy as np
import plotly.graph_objects as go

def view_grid():
    vol = psdr.VolumeGrid("volume.vol")
    data = np.array(vol.m_data)
    data = data.reshape(vol.size[::-1])
    data = np.transpose(data, (2, 1, 0))
    X, Y, Z = np.mgrid[:vol.size[0], :vol.size[1], :vol.size[2]]
    fig = go.Figure(data=go.Volume(
        x=X.flatten(), y=Y.flatten(), z=Z.flatten(),
        value=data.flatten(),
        isomin=0.2,
        isomax=0.7,
        opacity=0.1,
        surface_count=25,
    ))
    fig.update_layout(scene_xaxis_showticklabels=False,
                      scene_yaxis_showticklabels=False,
                      scene_zaxis_showticklabels=False)
    fig.show()

def test_grid():
    vol = psdr.VolumeGrid("volume.vol")
    d_vol = psdr.VolumeGrid("volume.vol")
    d_vol.setZero()
    p = [0.5, 0.5, 0.5]
    val = vol.lookupFloat(p)
    d_val = 1.0
    psdr.test.d_lookupFloat(vol, d_vol, p, val, d_val)
    print(d_vol.lookupFloat([0, 0, 0]))
    print(d_vol.lookupFloat([0, 0, 1]))
    print(d_vol.lookupFloat([0, 1, 1]))
    print(d_vol.lookupFloat([0, 1, 0]))
    print(d_vol.lookupFloat([1, 0, 0]))
    print(d_vol.lookupFloat([1, 0, 1]))
    print(d_vol.lookupFloat([0, 1, 0]))
    print(d_vol.lookupFloat([1, 1, 1]))


if __name__ == "__main__":
    test_grid()
