# Instructions
## Folders
* psdr: Codes for a special version of ```psdr-cuda```.
* implicit_stage: Codes and data for the implicit stage. We included two synthetic examples, chair and pegasus, to showcase.
* explicit_stage: Codes for the explicit stage.
## PSDR Compilation
Our inverse rendering pipeline relies on a special version of ```psdr-cuda``` (https://psdr-cuda.readthedocs.io/en/latest/index.html), included in the psdr directory. To compile it, change the working directory to ```psdr``` and follow the instruction at https://psdr-cuda.readthedocs.io/en/latest/core_compile.html to compile the code. 

## Running the inverse rendering pipeline
As described in the paper, our inverse rendering pipeline is splited into an implicit stage and an explicit stage. We will start by running the implicit stage. 

### Implicit stage
Since we will use synthetic examples, we will start by rendering some target images:
```
cd implicit_stage
python tools.py render_target_env [scene]
```
where ```[scene]``` can be either ```chair_env``` or ```pegasus_env```. The generated target images and their silhouette images will be located in the respective scene directory. 

Then, we we can run the implicit stage by:
```
python run_opt.py [scene]
```
You can find the visualization images for the training process in the ```results_direct``` directory in the respective scene diretory.

Below are the Python libraries required to run our code:
```
pytorch 
numpy
skimage
cv2
nvidia-ml-py3
```
We did our tests with Python 3.8.8 and the latest versions of above libraries that are compatible with Python 3.8.8.

### Explicit stage

Following dependency required:
#### Instant Meshes: https://github.com/wjakob/instant-meshes

Robust remeshing.

#### Boundary First Flattening: https://geometrycollective.github.io/boundary-first-flattening/

#### Remap-uv
Robust UV mapping for mesh. Alternatively, Microsoft's UVAtlas (https://github.com/microsoft/UVAtlas) can be used, but it can generate self-intersections in the output. 

#### MeshFix: https://github.com/MarcoAttene/MeshFix-V2.1

Robustly fixes small problems in meshes such as removing self-intersections, fixing non-manifold issues, filling holes, and returning a water-tight mesh.

Before running the explicit stage, make sure to put the result of the implicit stage in ```data``` with the correct format. We already provide an example result for ```chair_env``` and ```pegasus_env```
Then, we we can run the explicit stage by:
```
python run.py [scene]
```
It will automatically generate debug output images in ```output``` directory in the respective scene diretory.
