import subprocess
import sys
from argparse import ArgumentParser
from pathlib import Path

parser = ArgumentParser()
parser.add_argument('scene_name', type=str)
args = parser.parse_args()
scene_name = args.scene_name
init_dir = Path('data', 'mesh', scene_name, 'init')

# Render the target images
subprocess.run([sys.executable, 'render_target.py', f'--scene={scene_name}'])

# Remesh & recompute uv-coordinates to improve the quality of the mesh
subprocess.run([sys.executable, 
    'remesh.py', 
    init_dir / 'init.obj', 
    init_dir / 'mesh.obj', 
    '100000'])

# Remap the textures since uv-coordinates have changed 
subprocess.run([
    'remap-uv', 
    init_dir / 'init.obj', 
    init_dir / 'mesh.obj', 
    init_dir / 'diff_init.exr', 
    init_dir / 'spec_init.exr',
    init_dir / 'roug_init.exr',
    init_dir / 'diff.exr',
    init_dir / 'spec.exr',
    init_dir / 'roug.exr'])

# Upsample the textures
subprocess.run([sys.executable, 'upsample.py', init_dir / 'diff.exr', init_dir / 'diff.exr', '1024'])
subprocess.run([sys.executable, 'upsample.py', init_dir / 'spec.exr', init_dir / 'spec.exr', '1024'])
subprocess.run([sys.executable, 'upsample.py', init_dir / 'roug.exr', init_dir / 'roug.exr', '256'])

# Run the optimization
subprocess.run([sys.executable, 'optimize.py', f'--scene={scene_name}', '--json=config'])