import numpy as np 
import argparse
import os 
import cv2 

parser = argparse.ArgumentParser()
parser.add_argument('input',  type=str)
parser.add_argument('output', type=str)
parser.add_argument('size', type=int)
args = parser.parse_args()

tex1 = cv2.imread(args.input, cv2.IMREAD_UNCHANGED)

res = tex1.shape[0]
dim = len(tex1.shape)

if dim == 2:
	tex2 = cv2.resize(tex1, dsize=(args.size, args.size), interpolation=cv2.INTER_CUBIC)
	cv2.imwrite(args.output, tex2)
else:
	meanval = tex1[:,:,0].reshape(-1)
	meanval = meanval[meanval>0]
	mean0 = meanval.mean()

	meanval = tex1[:,:,1].reshape(-1)
	meanval = meanval[meanval>0]
	mean1 = meanval.mean()

	meanval = tex1[:,:,2].reshape(-1)
	meanval = meanval[meanval>0]
	mean2 = meanval.mean()

	temp = tex1[:,:,0].reshape(-1)
	temp = np.select([temp>0], [temp], [mean0])
	tex1[:,:,0] = temp.reshape(res, res)

	temp = tex1[:,:,1].reshape(-1)
	temp = np.select([temp>0], [temp], [mean1])
	tex1[:,:,1] = temp.reshape(res, res)

	temp = tex1[:,:,2].reshape(-1)
	temp = np.select([temp>0], [temp], [mean2])
	tex1[:,:,2] = temp.reshape(res, res)

	tex2 = cv2.resize(tex1, dsize=(args.size, args.size), interpolation=cv2.INTER_CUBIC)

	cv2.imwrite(args.output, tex2)
