# Efficient Differentiation of Pixel Reconstruction Filters for Path-Space Differentiable Rendering
### [Project](https://shuangz.com/projects2/psdr-pixel-sa22/) | [Paper](https://shuangz.com/projects2/psdr-pixel-sa22/psdr-pixel-sa22.pdf) | [Supplement](https://shuangz.com/projects2/psdr-pixel-sa22/supp/)

## System Requirements
Currently, our implementation only supports Linux. We have tested our implementation on Ubuntu 20.04 LTS.

## Dependencies
The dependencies of this project can be installed by the following shell script
```bash
source install.sh
```

We also provide a `Dockerfile` for setting up an environment for building and running the project. If you are using Visual Studio Code, you can directly open the project in the container.

## Compilation
We use two different configurations for differentiable rendering and inverse rendering.

Use the following script to compile our code for differentiable rendering:
```bash
source build_dr.sh
```
Use the following script to compile our code for inverse rendering:
```bash
source build_ir.sh
```
## Running Experiments
We provide two differentiable rendering examples and one inverse rendering example in the paper_results directory. We can run each of them using the following commands.
### Differentiable Rendering
#### Duck
```bash
cd validation/duck
python3 ../val.py default.conf                # forward rendering
python3 ../val.py path2_backward_noanti.conf  # baseline
python3 ../val.py path2_backward.conf         # ours
```

#### Volume Jumpy Dumpty
```bash
cd validation/vol_jumpy_dumpty
python3 ../val.py default.conf        # forward rendering
python3 ../val.py volpath_back0.conf  # baseline
python3 ../val.py volpath_back1.conf  # ours
```
### Inverse Rendering

#### Glossy terrain
```bash
cd inverse_rendering/terrain
python3 ../preprocess.py base.conf        # forward rendering
python3 ../optimize.py no_anti.conf       # baseline
python3 ../optimize.py with_anti.conf     # ours
```

#### Pig
```bash
cd inverse_rendering/pig
python3 ../preprocess.py base.conf        # forward rendering
python3 ../optimize.py no_anti.conf       # baseline
python3 ../optimize.py with_anti.conf     # ours
```