#!/bin/bash

UBUNTU_VERSION=20.04
LLVM_VERSION=12

apt-get update && apt-get install -y --no-install-recommends \
sudo ca-certificates software-properties-common curl gnupg2 wget \
git ssh zlib1g-dev automake autoconf cmake make lldb ninja-build gcc g++ gfortran build-essential libtool \
llvm-$LLVM_VERSION-dev clang-format clang-$LLVM_VERSION lld-$LLVM_VERSION libclang-$LLVM_VERSION-dev libomp-$LLVM_VERSION-dev \
libglfw3-dev libtbb-dev libblas-dev libeigen3-dev libboost-dev libopenexr-dev python3 python3-dev python3-pip python-is-python3

wget \
https://repo.anaconda.com/miniconda/Miniconda3-py38_4.12.0-Linux-x86_64.sh \
&& mkdir /root/.conda \
&& bash Miniconda3-py38_4.12.0-Linux-x86_64.sh -b \
&& rm -f Miniconda3-py38_4.12.0-Linux-x86_64.sh 

pip3 install torch==1.10.0+cpu torchvision==0.11.1+cpu torchaudio==0.10.0+cpu -f https://download.pytorch.org/whl/cpu/torch_stable.html \
&& pip3 install OpenEXR scikit-image pytest gin-config opencv-python==4.3.0.38 \
&& conda install -c conda-forge igl

# build embree
git clone https://github.com/embree/embree.git \
&& cd embree \
&& mkdir -p build \
&& cd build \
&& cmake -DCMAKE_CXX_COMPILER=g++ -DCMAKE_C_COMPILER=gcc -DEMBREE_ISPC_SUPPORT=OFF .. \
&& sudo make install -j8

# build enzyme
git clone https://github.com/wsmoses/Enzyme.git && cd Enzyme \
&& git checkout v0.0.30 \
&& cd enzyme \
&& mkdir build && cd build \
&& CC=clang-12 CXX=clang++-12 cmake -G Ninja .. -DLLVM_DIR=/usr/lib/llvm-12/lib/cmake/llvm/ \
&& ninja \
&& ninja install

ln -s /usr/bin/clang-12 /usr/bin/clang \
&& ln -s /usr/bin/clang++-12 /usr/bin/clang++ \
&& ln -s /usr/bin/llvm-link-12 /usr/bin/llvm-link \
&& ln -s /usr/bin/opt-12 /usr/bin/opt \
&& conda init bash