#pragma once
#include <core/fwd.h>

struct Scene;
struct Shape;
namespace pugi
{
    class xml_document;
    class xml_node;
} // namespace pugi

NAMESPACE_BEGIN(psdr)

class SceneLoader
{
public:
    static void load_from_file(const char *file_name, Scene &scene);
    static void load_from_string(const char *scene_xml, Scene &scene);
    static Scene load_from_string1(const char *scene_xml);

protected:
    static void load_scene(const pugi::xml_document &doc, Scene &scene);
    static void load_sensor(const pugi::xml_node &node, Scene &scene);
    // static void load_emitter(const pugi::xml_node &node, Scene &scene);
    static void load_bsdf(const pugi::xml_node &node, Scene &scene);
    static void load_shape(const pugi::xml_node &node, Scene &scene);
    static void load_medium(const pugi::xml_node &node, Scene &scene);
    // create a phase function in scene and return the index
    static int create_phase(const pugi::xml_node &node, Scene &scene);
    static void load_ref(const pugi::xml_node &node, Scene &scene, Shape &shape);
};

NAMESPACE_END(psdr)
