import numpy as np
from pypsdr.utils.io import imread, imwrite
import argparse, os

if __name__ == "__main__":
    parser = argparse.ArgumentParser(
            description='Script for simple EXR utilities',
            epilog='Cheng Zhang (chengz20@uci.edu)')

    parser.add_argument('filename', metavar='filename', type=str, help='input filename')
    args = parser.parse_args()
    dirname = os.path.dirname(args.filename)
    os.chdir(dirname)
    filename = os.path.basename(args.filename)
    filename_without_ext = os.path.splitext(filename)[0]
    image = imread(filename)
    imwrite(image, filename_without_ext + '.png')