import logging
import datetime

logger = logging.getLogger(__name__)

class Timer:
    def __init__(self, name = None):
        self.name = name
        self.start = None
        self.end = None

    def __enter__(self):
        self.start = datetime.datetime.now()
        return self

    def __exit__(self, *args):
        self.end = datetime.datetime.now()
        diff = self.end - self.start
        diff = diff.seconds + diff.microseconds / 1000000.0
        logger.info("Total time for %s : %f s", self.name, diff)

if __name__ == "__main__":
    logger.info("This is a test")