#pragma once
#ifndef BSDF_NULL_H__
#define BSDF_NULL_H__

#include <render/bsdf.h>

struct NullBSDF : BSDF
{
    BSDF *clone() const override;
    void merge(BSDF *bsdf) override {}
    void setZero() override {}

    Spectrum eval(const Intersection &its, const Vector &wo,
                  EBSDFMode mode = EBSDFMode::ERadiance) const;
    Spectrum sample(const Intersection &its, const Array3 &sample,
                    Vector &wo, Float &pdf, Float &eta,
                    EBSDFMode mode = EBSDFMode::ERadiance) const;
    Float pdf(const Intersection &its, const Vector &wo) const;
    inline bool isTransmissive() const { return true; }
    inline bool isTwosided() const { return true; }
    inline bool isNull() const { return true; }
    std::string toString() const override
    {
        std::ostringstream oss;
        oss << "BSDF_null []" << std::endl;
        return oss.str();
    }
    DECLEAR_BSDF_HELPER_FUNCTIONS()
    PSDR_DECLARE_CLASS(NullBSDF)
    PSDR_IMPLEMENT_VIRTUAL_CLASS(NullBSDF)
};

#endif
