#pragma once
#include <render/integrator.h>

struct RndSampler;
struct Ray;

struct Direct : Integrator
{
    Spectrum radiance(const Scene &scene, RndSampler *sampler, Ray &ray,
                      const Array2i &pixel_idx) const;

    Spectrum Li(const Scene &scene, RndSampler *sampler, const Array2i &pixel_idx) const;
    void d_Li(SceneAD &scene, const Array2i &pixel_idx,
              RndSampler *sampler, int n_samples, Spectrum &d_res) const;

    void render(const Scene &scene, const RenderOptions &options,
                ptr<float> rendered_image) const;

    ArrayXd renderC(const Scene &scene, const RenderOptions &options) const;
    ArrayXd renderD(SceneAD &sceneAD,
                    const RenderOptions &options, const ArrayXd &d_image) const;
};