#pragma once
#include <render/integrator.h>

struct RndSampler;
struct Ray;
struct LightPath;

namespace volpath_meta
{
    Spectrum __Li(const Scene &scene, const Ray &_ray, const RadianceQueryRecord &rRec, LightPath *path);
}

struct Volpath : UnidirectionalPathTracer
{
    Spectrum Li(const Scene &scene, const Ray &ray, RadianceQueryRecord &rRec) const override;
    // Li2 uses Lins
    Spectrum Li2(const Scene &scene, const Ray &ray, RadianceQueryRecord &rRec) const;
    void LiAD(SceneAD &sceneAD, const Ray &ray, RadianceQueryRecord &rRec, const Spectrum &d_res) const override;
    Spectrum Lins(const Scene &scene, const Vector &p, const Vector &wi, const Medium *medium, const RadianceQueryRecord &rRec) const;
    Spectrum LiFwd(SceneAD &sceneAD, const Ray &ray, RadianceQueryRecord &rRec) const override;

    std::string getName() const override { return "Volpath"; }
};
