#include <render/phase.h>

Float PhaseFunction::sample(const Vector &wi, const Vector2 &rnd2, Vector &wo) const
{
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "HGPhaseFunction") == 0)
        return static_cast<const HGPhaseFunction *>(this)->sample(wi, rnd2, wo);
    if (strcmp(name, "IsotropicPhaseFunction") == 0)
        return static_cast<const IsotropicPhaseFunction *>(this)->sample(wi, rnd2, wo);
    assert(false);
    return 0;
}
Float PhaseFunction::pdf(const Vector &wi, const Vector &wo) const
{
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "HGPhaseFunction") == 0)
        return static_cast<const HGPhaseFunction *>(this)->pdf(wi, wo);
    if (strcmp(name, "IsotropicPhaseFunction") == 0)
        return static_cast<const IsotropicPhaseFunction *>(this)->pdf(wi, wo);
    assert(false);
    return 0;
}
Float PhaseFunction::eval(const Vector &wi, const Vector &wo) const
{
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "HGPhaseFunction") == 0)
        return static_cast<const HGPhaseFunction *>(this)->eval(wi, wo);
    if (strcmp(name, "IsotropicPhaseFunction") == 0)
        return static_cast<const IsotropicPhaseFunction *>(this)->eval(wi, wo);
    assert(false);
    return 0;
}

PSDR_INACTIVE_CLASS(PhaseFunction)
INACTIVE_FN(PhaseFunction_pdf, &PhaseFunction::pdf);
INACTIVE_FN(PhaseFunction_sample, &PhaseFunction::sample);