#include <catch2/catch.hpp>
#include <fwd.h>
#include <logger.h>
#include <iostream>
namespace
{
    Array parse_vector(const char *str, bool allow_empty = false)
    {
        Array result;
        int tot = 0;

        int i = 0;
        for (;;)
        {
            while (str[i] && strchr(", ", str[i]))
                ++i;
            if (!str[i])
                break;

            int j = i + 1;
            while (str[j] && strchr(", ", str[j]) == nullptr)
                ++j;

            PSDR_ASSERT(tot < 3);
            result[tot++] = static_cast<float>(atof(str + i));

            i = j;
        }

        if (tot < 3)
        {
            if (allow_empty)
            {
                float value = tot ? result[tot - 1] : 0.0f;
                std::fill(result.data() + tot, result.data() + 3, value);
            }
            else
            {
                PSDR_ASSERT_MSG(false, std::string("Vector too short: [") + str + "]");
            }
        }

        return result;
    }
}

TEST_CASE("XMLParser", "[xmlparser]")
{
    std::cout << parse_vector("1.234,2.3, 3.3") << std::endl;
}