// Copyright @yucwang 2023

#include "../Integrator.h"
#include "ReSTIR/MaterialSpaceReSTIR.h"

#include <random>

namespace EDX {
namespace TensorRay {

class PixelBoundaryIntegrator2 : public Integrator
{
public:
    PixelBoundaryIntegrator2() : Integrator(),
        mPathSampler(MaterialSpaceReSTIRPathSampler::GetInstance()),
        mAntitheticSpp(4) {
            std::random_device rd;
            randomGenerator = std::mt19937(rd());
        }

    void SetParam(const RenderOptions& options)
    {
        const RISRenderOptions& _options = dynamic_cast<const RISRenderOptions&>(options);
        M = _options.Me0;
        haveTemporalReuse = _options.haveTemporalReuse;
        k = _options.pixelBoundaryK;
        k1 = _options.pixelBoundaryK1;
        historyLength = _options.historyLength;
        mSpp = _options.mSppPixelBoundary;
        mSppBatch = _options.mSppPixelBoundaryBatch;
        mMaxBounces = _options.mMaxBounces;
        mVerbose = !_options.mQuiet;
        reservoirMergeNormalThreshold = _options.reservoirMergeNormalThreshold;
        reservoirMergeDistThreshold = _options.reservoirMergeDistThreshold;

        reservoirToUse.clear();
        for (int i = 0; i < this->k; ++i) reservoirToUse.push_back(i);
    }

    void Integrate(const Scene& scene, Tensorf& image) const;
    void SampleEmitter(const Scene& scene, const Ray& rays, Intersection& its, SpatialVertices& spatialS1, 
                        SpatialVertices& spatialLight) const;

    std::shared_ptr<Reservoir> PrefilerReservoir(const Scene& scene, 
        const std::shared_ptr<Reservoir>& reservoir,
        const Camera& camera,
        const Tensorf& curPosition) const;
    int mAntitheticSpp;

private:
    int M;
    mutable bool haveTemporalReuse;
    int k;
    int k1;
    int historyLength;
    float reservoirMergeNormalThreshold;
    float reservoirMergeDistThreshold;
    std::shared_ptr<MaterialSpaceReSTIRPathSampler> mPathSampler;

    mutable std::mt19937 randomGenerator;
    mutable std::vector<int> reservoirToUse;
};

}
}