// Copyright @yucwang 2022

#include "../Integrator.h"
#include "ReSTIR/MaterialSpaceReSTIR.h"

#include <random>

namespace EDX {
namespace TensorRay {

class PrimaryBoundaryIntegrator2 : public Integrator
{
public:
    PrimaryBoundaryIntegrator2(): Integrator(), 
        mPathSampler(MaterialSpaceReSTIRPathSampler::GetInstance()) {
        std::random_device rd;
        randomGenerator = std::mt19937(rd());
    }

    void SetParam(const RenderOptions& options) 
    {
        const RISRenderOptions& _options = dynamic_cast<const RISRenderOptions&>(options);
        M = _options.Me0;
        haveTemporalReuse = _options.haveTemporalReuse;
        k = _options.k;
        k1 = _options.k1;
        mSpp = options.mSppPrimary;
        mSppBatch = options.mSppPrimaryBatch;
        mMaxBounces = options.mMaxBounces;
        historyLength = _options.historyLength;
        mVerbose = !options.mQuiet;
        reservoirMergeNormalThreshold = _options.reservoirMergeNormalThreshold;
        reservoirMergeDistThreshold = _options.reservoirMergeDistThreshold;
        // mPathSampler->SetParam(options);

        reservoirToUse.clear();
        for (int i = 0; i < this->k; ++i) reservoirToUse.push_back(i);
    }

    void Integrate(const Scene& scene, Tensorf& image) const;
    virtual void Step() override;

private: 
    void SampleEmitter(const Scene& scene, const Ray& rays, Intersection& its, SpatialVertices& spatialS1, 
                        SpatialVertices& spatialLight) const;
    std::shared_ptr<Reservoir> PrefilerReservoir(const Scene& scene, 
        const std::shared_ptr<Reservoir>& reservoir,
        const Camera& camera,
        const Tensorf& curPosition) const;

private:
    int M;
    mutable bool haveTemporalReuse;
    int k;
    int k1;
    int historyLength;
    float reservoirMergeNormalThreshold;
    float reservoirMergeDistThreshold;
    std::shared_ptr<MaterialSpaceReSTIRPathSampler> mPathSampler;

    mutable std::mt19937 randomGenerator;
    mutable std::vector<int> reservoirToUse;
};

} // namespace TensorRay
} // namespace EDX