// Copyright @yucwang 2022

#pragma once
#ifndef LIBTENSORRAY_ALGORITHM1_RESTIR_SCREENSPACERESTIR_H_
#define LIBTENSORRAY_ALGORITHM1_RESTIR_SCREENSPACERESTIR_H_
#endif

#include "../PathSampler.h"
#include "ReSTIRDataTypes.h"

namespace EDX {

namespace TensorRay {

class ScreenSpaceReSTIRPathSampler: public PathSampler
{
public:
    virtual void SetParam(const RenderOptions& options) override;

    virtual void SamplePaths(const Scene& scene, PathSampleResult& res) const override;

    int M;
    bool haveTemporalReuse;
    mutable Reservoir reservoir;

    mutable Scene prevReferenceSpace;
};

void EvalScreenSpaceReSTIR(const Scene& scene, 
                           const SpatialVertices& vCamera, 
                           const SpatialVertices& vCur, 
                           const SpatialVertices& vLight, 
                           Tensorf& res);

} // namespace TensorRay
} // namespace EDX