// Copyright @yucwang 2023

#pragma once
#ifndef CUKD_TYPES_H_
#define CUDK_TYPES_H_

namespace cukd {

template<typename _point_t, typename scalar_t>
struct FCPPoint {
    typedef _point_t point_t;
    point_t p;
    int originalId;

    inline static __device__
    scalar_t get(point_t p, int dim) {
        return ((scalar_t*)&p)[dim];
    }
};
typedef FCPPoint<float3, float> FCPPointF3;

template<typename _point_t, typename scalar_t>
struct FCPPointInterface
{
  typedef _point_t point_t;
  inline static __device__
  scalar_t get(const point_t &p, int dim) { return ((scalar_t*)&p)[dim]; }
};

} // namespace cukd

#endif // CUKD_TYPES_H_