# Amortizing Samples in Physics-Based Inverse Rendering using ReSTIR

## Introduction

This repo includes source code for our [SIGGRAPH ASIA 2023 paper](https://shuangz.com/projects/psdr-restir-sa23/).  

## Build

Our work is based on `TensorRay`, a CUDA-based differentiable renderer. Please make sure your environment meets the following requirements:  

```
Windows 10
Visual Studio 2019
CUDA 11.5 (Exact)
CMake >= 3.23
Python >= 3.7
```

To build the project, please run the following cmake command:
```shell
// Under project root, make a build dir and go to there
mkdir build
cd build
// Generate CMake configuration file
cmake -DCUDATookit_ROOT="{Path to your CUDA toolkit, optional}" \
    -DCMAKE_CUDA_COMPILER="{Path to your NVCC compiler}" \ 
    -G "Visual Studio 16 2019" -A x64 ..
```

To run the inverse rendering script, please install the following python library.  
```
opencv-contrib-python
gin
tensorboard
dataclasses
pyexr
igl
largesteps
pytorch
numpy
scipy
```

## Run Inverse Rendering Experiment

This repo includes the `World Map` example shown in the paper. To run this example, first go to `{Project Root}/example/inverse_rendering/`. Then we need to generate target images first, please run the following command:  
```shell
python target_generator_multiview.py ./world_map/target.conf
```

After this, the target images are supposed to be in `example/inverse_rendering/output/world_map_1/target`.  

Then we can run the inverse rendering experiment:
```
python inv_rendering.py ./world_map/ReSTIR.conf
```

After this, the results will be in `example/inverse_rendering/output/world_map_1/ReSTIR`. We can see the optimization curve using `Tensorboard`:
```
tensorboard --logdir ./output/world_map_1/ReSTIR
``` 

## Implementation Details

The main implementation are included in the following source files:
`LibTensorRay/Renderer/Algorithm1/ReSTIR`: A ReSTIR implementation for light sampling in interior term of PSDR.  
`LibTensorRay/Renderer/Algorithm1/BoundaryDirect2.cpp`: ReSTIR for secondary boundary term of PSDR, including edge sampling guiding based upon ReSTIR.  
`LibTensorRay/Renderer/Algorithm1/BoundaryPrimary2.cpp`: ReSTIR for primary boundary term of PSDR.  
`LibTensorRay/Renderer/Algorithm1/BoundaryPixel2.cpp`: ReSTIR for pixel boundary term of PSDR, this includes ReSTIR for pixel filter antithetic sampling.  

## License

This code is licensed under BSD-3-Clause license. Please also refer to [TensorRay's README](./README_TensorRay.md) for more details.  