# TensorRay

TensorRay is a physics-based differenetiable renderer written in C++17/CUDA and running on the GPU. 
It is based on the theoretical framework introduced in the paper titled [Path-Space Differentiable Rendering](https://shuangz.com/projects/psdr-sg20/).

## Build

Prerequisites:  
- Windows 10
- CUDA == 11.5
- Optix >= 7.4
- Pybind11
- Miniz

First, clone this project from Github:
```
git clone https://github.com/behindthepixels/TensorRay --recursive
```

We provided precompiled binaries for quick set up. Please download `pybind11` and `optix` from [here](https://drive.google.com/drive/folders/1-H8knPaY5HTia2nQusWF3LZoKVg5eU2U?usp=sharing) and place it under `/path/to/TensorRay/ext_win64` and download `miniz` from [here](https://drive.google.com/drive/folders/1oI0kyRe-3SiVVi7hhjKj2WXjSmjvEpVt?usp=sharing) and place it under `/path/to/miniz/ext_win64`. 

We use `cmake` for building this system, to build the system, please do the following steps:  
```
mkdir build
cd build
cmake -DCUDA_NVCC_FLAGS="-arch=sm_86" -DPYTHON_ROOT="C:/Users/User/Anaconda3" -G "Visual Studio 16 2019" -A x64 ..
cmake --build . -j --config Release
copy /y lib\Release\*.pyd lib\
```

**Important Step**: Python will not look for `dll` library from `PATH` environment variable.(Please refer to [here](https://bugs.python.org/issue43173)). To make sure you can actually run the python library, please find and copy `curand`, `cublas`, `cublas_Lt` to the same directory as our output python library.  

## Doc for Public Version of TensorRay

Please see the [documentation](https://tensorray.readthedocs.io/en/latest/) for details on how to compile and use TensorRay.

## License
This code is licensed under BSD-3-Clause license. Please see `LICENSE.txt` for details.
