function addAnimation(id, height, start, end, fps, interval, files) {
    'use strict'

    var nframes = (end - start)/interval;
    var imgs = new Array(nframes);
    var totLoaded = 0;

    for ( var i = start; i < end; i+=interval ) {
        var j = (i - start)/interval;
        imgs[j] = new Image();
        imgs[j].onload = function() {
            if ( ++totLoaded == nframes ) {
                var canvasId = id + "_canvas";
                $("#" + id).css("background-image", "none").css("height", "auto")
                           .append("<canvas id='" + canvasId + "'></canvas>");
                var canvasObj = $("#" + canvasId);
                var ctx = canvasObj[0].getContext("2d");

                var h = height, scl = height/imgs[0].height;
                var w = imgs[0].width*scl;

                canvasObj.attr("width", w);
                canvasObj.attr("height", h);
                ctx.scale(scl, scl);

                canvasObj.css("display", "block");
                canvasObj.css("cursor", "pointer");
                ctx.drawImage(imgs[0], 0, 0);

                var playing = false;
                var curFrame = 0;
                var timer = null;
                canvasObj.click(function() {
                    if ( !playing ) {
                        playing = true;
                        timer = setInterval(function() {
                            if ( curFrame == nframes ) {
                                clearTimeout(timer);
                                playing = false;
                                curFrame = 0;
                            }
                            else {
                                ctx.drawImage(imgs[curFrame++], 0, 0);
                            }
                        }, 1000/fps);
                    } else {
                        clearTimeout(timer);
                        playing = false;
                    }
                }).contextmenu(function() {
                    clearTimeout(timer);
                    playing = false;
                    ctx.drawImage(imgs[curFrame = 0], 0, 0);
                    return false;
                });
            }
        };
        imgs[j].src = sprintf(files, i);
    }
}

$(document).ready(function() {
    'use strict'
    addAnimation("AdobeStock_132871873_obj", 200, 0, 31, 10, 1, "img_data/AdobeStock_132871873/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_14150707_obj", 200, 0, 11, 10, 1, "img_data/AdobeStock_14150707/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_14528000_obj", 200, 0, 11, 10, 1, "img_data/AdobeStock_14528000/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_18717953_obj", 200, 0, 31, 10, 1, "img_data/AdobeStock_18717953/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_191423289_obj", 200, 0, 21, 10, 1, "img_data/AdobeStock_191423289/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_243838142_obj", 200, 0, 31, 10, 1, "img_data/AdobeStock_243838142/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_27580045_obj", 200, 0, 31, 10, 1, "img_data/AdobeStock_27580045/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_283657750_obj", 200, 0, 31, 10, 1, "img_data/AdobeStock_283657750/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_305590989_obj", 200, 0, 31, 10, 1, "img_data/AdobeStock_305590989/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_5889655_obj", 200, 0, 31, 10, 1, "img_data/AdobeStock_5889655/obj/frame_%03d.jpg");
    addAnimation("AdobeStock_6004914_obj", 200, 0, 31, 10, 1, "img_data/AdobeStock_6004914/obj/frame_%03d.jpg");
    addAnimation("IM2CAD_1_obj", 200, 0, 41, 10, 1, "img_data/IM2CAD_1/obj/frame_%03d.jpg");
    addAnimation("IM2CAD_2_obj", 200, 0, 11, 10, 1, "img_data/IM2CAD_2/obj/frame_%03d.jpg");
    addAnimation("IM2CAD_3_obj", 200, 0, 31, 10, 1, "img_data/IM2CAD_3/obj/frame_%03d.jpg");

    addAnimation("AdobeStock_132871873_fine", 200, 0, 24, 10, 1, "img_data/AdobeStock_132871873/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_14150707_fine", 200, 0, 24, 10, 1, "img_data/AdobeStock_14150707/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_14528000_fine", 200, 0, 17, 10, 1, "img_data/AdobeStock_14528000/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_18717953_fine", 200, 0, 24, 10, 1, "img_data/AdobeStock_18717953/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_191423289_fine", 200, 0, 26, 10, 1, "img_data/AdobeStock_191423289/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_243838142_fine", 200, 0, 24, 10, 1, "img_data/AdobeStock_243838142/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_27580045_fine", 200, 0, 23, 10, 1, "img_data/AdobeStock_27580045/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_283657750_fine", 200, 0, 24, 10, 1, "img_data/AdobeStock_283657750/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_305590989_fine", 200, 0, 21, 10, 1, "img_data/AdobeStock_305590989/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_5889655_fine", 200, 0, 24, 10, 1, "img_data/AdobeStock_5889655/fine/frame_%03d.jpg");
    addAnimation("AdobeStock_6004914_fine", 200, 0, 24, 10, 1, "img_data/AdobeStock_6004914/fine/frame_%03d.jpg");
    addAnimation("IM2CAD_1_fine", 200, 0, 23, 10, 1, "img_data/IM2CAD_1/fine/frame_%03d.jpg");
    addAnimation("IM2CAD_2_fine", 200, 0, 18, 10, 1, "img_data/IM2CAD_2/fine/frame_%03d.jpg");
    addAnimation("IM2CAD_3_fine", 200, 0, 23, 10, 1, "img_data/IM2CAD_3/fine/frame_%03d.jpg");
});
