# psdr: Path-Space Differentiable Renderer

*psdr* is a physics-based differentiable renderer computes derivative images with respect to arbitrary scene parameters (e.g., object geometries and material properties). 

## Installation
1. install all the dependencies with the provided script (You can also install them manually)
```
./install.sh
exec bash -l
```
2. install the `psdr` & `pypsdr` library
```
mkdir build
cd build
cmake ..
sudo make install -j
```

## Dependencies

dtrt depends on a few libraries/systems, which are all included in the repository:
- [Eigen3](http://eigen.tuxfamily.org)
- [Python 3.6 or above](https://www.python.org)
- [pybind11](https://github.com/pybind/pybind11)
- [PyTorch 1.0 or above](https://pytorch.org)
- [OpenEXR](https://github.com/openexr/openexr)
- [Embree](https://embree.github.io)
- [OpenEXR Python](https://github.com/jamesbowman/openexrpython)
- A few other python packages: numpy, scikit-image


## Examples
In the submission version, we provide the script to reproduce the results of paper examples [Branches] and [Veach].
(1) To generate the original image at the initial & target setting 
```
python3 run.py -mode=1
```
(2) To generate gradient image at current scene setting
```
python3 run.py -mode=2
```
(3) To run the optimization
```
python3 run.py
```
