#pragma once
#ifndef TEXTURED_BSDF_DIFFUSE_H__
#define TEXTURED_BSDF_DIFFUSE_H__

#include "bsdf.h"
#include "ptr.h"
#include <vector>

struct TexturedDiffuseBSDF: BSDF {
    TexturedDiffuseBSDF(int width, int height, Eigen::Matrix<Float, -1, 3> &reflectance);
    TexturedDiffuseBSDF(int width, int height, ptr<float> reflectance);

    Spectrum evalUV(const Vector2 &uv) const;
    SpectrumAD evalUV_AD(const Vector2AD &uv) const;

    Spectrum eval(const Intersection &its, const Vector &wo, EBSDFMode mode = EBSDFMode::ERadiance) const;
    SpectrumAD evalAD(const IntersectionAD &its, const VectorAD &wo, EBSDFMode mode = EBSDFMode::ERadiance) const;
    Spectrum sample(const Intersection &its, const Array3 &rnd, Vector &wo, Float &pdf, Float &eta, EBSDFMode mode = EBSDFMode::ERadiance) const;
    Float pdf(const Intersection &its, const Vector &wo) const;

    inline bool isTransmissive() const { return false; }
    inline bool isTwosided() const { return false; }
    inline bool isNull() const { return false; }

    std::string toString() const {
        std::ostringstream oss;
        oss << "Textured_BSDF_diffuse [" << std::endl
            << "  width = " << width << ", height = " << height << std::endl
            << "]" << std::endl;
        return oss.str();
    }

    int width, height;
    std::vector<Spectrum> reflectance;
};

#endif //TEXTURED_BSDF_DIFFUSE_H__
