#pragma once
#ifndef BSDF_TWOSIDED_H__
#define BSDF_TWOSIDED_H__

#include "bsdf.h"
#include "ptr.h"

struct TwosidedBSDF: BSDF {
    inline TwosidedBSDF(const BSDF *nested) : m_nested(nested) { assert(!nested->isTransmissive()); }

    Spectrum eval(const Intersection &its, const Vector &wo, EBSDFMode mode = EBSDFMode::ERadiance) const;
    SpectrumAD evalAD(const IntersectionAD &its, const VectorAD &wo, EBSDFMode mode = EBSDFMode::ERadiance) const;
    Spectrum sample(const Intersection &its, const Array3 &rnd, Vector &wo, Float &pdf, Float &eta, EBSDFMode mode = EBSDFMode::ERadiance) const;
    Float pdf(const Intersection &its, const Vector &wo) const;

    inline bool isTransmissive() const { return false; }
    inline bool isTwosided() const { return true; }
    inline bool isNull() const { return false; }
    std::string toString() const {
        std::ostringstream oss;
        oss << "BSDF_diffuse [" << '\n'
            << m_nested->toString() << '\n'
            << "]" << std::endl;
        return oss.str();
    }

    const BSDF *m_nested;
};

#endif
