#include "area.h"
#include "intersection.h"
#include "intersectionAD.h"

Spectrum AreaLight::eval(const Intersection &its, const Vector &d) const {
    return its.geoFrame.n.dot(d) > Epsilon ? intensity.val : Spectrum::Zero();
}

SpectrumAD AreaLight::evalAD(const IntersectionAD &its, const VectorAD &d) const {
    return its.geoFrame.n.val.dot(d.val) > Epsilon ? intensity : SpectrumAD();
}

Spectrum AreaLight::eval(const Vector &norm, const Vector &d) const {
        return norm.dot(d) > Epsilon ? intensity.val : Spectrum::Zero();
}

SpectrumAD AreaLight::evalAD(const VectorAD &norm, const VectorAD &d) const {
        return norm.val.dot(d.val) > Epsilon ? intensity : SpectrumAD();
}

Float AreaLight::evalDirection(const Vector& norm, const Vector& d) const {
    Float dp = norm.dot(d);
    return dp > Epsilon ? dp : 0.0f;
}

FloatAD AreaLight::evalDirectionAD(const VectorAD& norm, const VectorAD& d) const {
    FloatAD dp = norm.dot(d);
    return dp > Epsilon ? dp : FloatAD(0.0f);
}

Float AreaLight::sampleDirection(const Array2 &rnd, Vector& dir, Float *pdf) const {
     dir = squareToCosineHemisphere(Vector2(rnd[0], rnd[1]));
     if ( pdf ) *pdf = squareToCosineHemispherePdf(dir);
     return M_PI;
}