#pragma once
#ifndef BIDIRECTIONAL_PATH_TRACER_AD_H__
#define BIDIRECTIONAL_PATH_TRACER_AD_H__

#include "integratorADps.h"
#include "bidir_utils.h"

struct BidirectionalPathTracerAD : IntegratorAD_PathSpace {
    void radiance(const Scene& scene, RndSampler* sampler, const Intersection &its, int max_bounces, Spectrum *ret) const;

    int weightedImportance(const Scene& scene, RndSampler* sampler, const Intersection& its, int max_bounces, const Spectrum *weight, std::pair<int, Spectrum>* ret) const;

    Spectrum pixelColor(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const;

    SpectrumAD pixelColorAD(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const;

    void render(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;
    std::string getName() const { return "bdptAD"; }

    mutable bidir::PathNodeAD m_pathAD[2*BDPT_MAX_THREADS][BDPT_MAX_PATH_LENGTH];
    mutable bidir::PathNode m_path[2*BDPT_MAX_THREADS][BDPT_MAX_PATH_LENGTH];
    mutable Spectrum m_rad[BDPT_MAX_THREADS][BDPT_MAX_PATH_LENGTH];

    mutable long long rejectedSamples;

};

#endif //BIDIRECTIONAL_PATH_TRACER_AD_H__
