#pragma once
#ifndef DIRECT_INTEGRATOR_AD_PATHSPACE_H__
#define DIRECT_INTEGRATOR_AD_PATHSPACE_H__

#include "integratorADps.h"

struct DirectIntegratorAD_PathSpace : IntegratorAD_PathSpace {
    Spectrum Li(const Scene& scene, RndSampler* sampler, Ray ray) const;
    SpectrumAD LiAD(const Scene& scene, RndSampler* sampler, const RayAD& ray) const;

    Spectrum pixelColor(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const;
    SpectrumAD pixelColorAD(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const;

    void render(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;

    std::string getName() const { return "directAD_ps"; }
};

#endif //DIRECT_INTEGRATOR_AD_PATHSPACE_H__
