function addAnimation(id, height, start, end, fps, interval, files) {
    'use strict'

    var nframes = (end - start)/interval;
    var imgs = new Array(nframes);
    var totLoaded = 0;

    for ( var i = start; i < end; i+=interval ) {
        var j = (i - start)/interval;
        imgs[j] = new Image();
        imgs[j].onload = function() {
            if ( ++totLoaded == nframes ) {
                var canvasId = id + "_canvas";
                $("#" + id).css("background-image", "none").css("height", "auto")
                           .append("<canvas id='" + canvasId + "'></canvas>");
                var canvasObj = $("#" + canvasId);
                var ctx = canvasObj[0].getContext("2d");

                var h = height, scl = height/imgs[0].height;
                var w = imgs[0].width*scl;

                canvasObj.attr("width", w);
                canvasObj.attr("height", h);
                ctx.scale(scl, scl);

                canvasObj.css("display", "block");
                canvasObj.css("cursor", "pointer");
                ctx.drawImage(imgs[0], 0, 0);

                var playing = false;
                var curFrame = 0;
                var timer = null;
                canvasObj.click(function() {
                    if ( !playing ) {
                        playing = true;
                        timer = setInterval(function() {
                            if ( curFrame == nframes ) {
                                clearTimeout(timer);
                                playing = false;
                                curFrame = 0;
                            }
                            else {
                                ctx.drawImage(imgs[curFrame++], 0, 0);
                            }
                        }, 1000/fps);
                    } else {
                        clearTimeout(timer);
                        playing = false;
                    }
                }).contextmenu(function() {
                    clearTimeout(timer);
                    playing = false;
                    ctx.drawImage(imgs[curFrame = 0], 0, 0);
                    return false;
                });
            }
        };
        imgs[j].src = sprintf(files, i);
    }
}

$(document).ready(function() {
    'use strict'

    // General inverse rendering
    addAnimation("tree_06", 700, 0, 140, 10, 2, "images/inverse_rendering/tree_06/frame_%03d.jpg");
    addAnimation("tree_02", 700, 0, 140, 10, 2, "images/inverse_rendering/tree_02/frame_%03d.jpg");
    addAnimation("veach", 550, 0, 200, 10, 2, "images/inverse_rendering/veach/frame_%03d.jpg");
    addAnimation("mug", 450, 0, 180, 10, 2, "images/inverse_rendering/mug/frame_%03d.jpg");
    addAnimation("ring", 240, 0, 160, 10, 2, "images/inverse_rendering/ring/frame_%03d.jpg");
    addAnimation("pufferball", 560, 0, 160, 10, 2, "images/inverse_rendering/pufferball/frame_%03d.jpg");
});
