import igl
import argparse
import os
import numpy as np

parser = argparse.ArgumentParser()
parser.add_argument('--input',  type=str,  default='sphere.obj')
parser.add_argument('--output', type=str,  default='out.obj')
parser.add_argument('--vertex', type=str,  default='5000')

args = parser.parse_args()

input_obj_fn = args.input 
output_obj_fn = args.output 
v, _, _, f, _, _ = igl.read_obj(input_obj_fn)
input_off_fn = input_obj_fn.replace(".obj", ".off")
igl.write_triangle_mesh(input_off_fn, v, f)

print("MeshFix:")
cmd = "MeshFix " + input_off_fn + " " + output_obj_fn
print(cmd)
os.system(cmd)

cmd = "rm " + input_off_fn
os.system(cmd)

print("Instant_meshes:")

cmd = "instant_meshes   -o " + args.output + " -t 32 -S 10 -d -p 6 -r 6 -v " + args.vertex + " " + args.output 
os.system(cmd)

input_obj_fn = args.output 
output_obj_fn = args.output 
v, _, _, f, _, _ = igl.read_obj(input_obj_fn)
input_off_fn = input_obj_fn.replace(".obj", ".off")
igl.write_triangle_mesh(input_off_fn, v, f)

print("MeshFix:")
cmd = "MeshFix " + input_off_fn + " " + output_obj_fn
print(cmd)
os.system(cmd)

cmd = "rm " + input_off_fn
os.system(cmd)
