import datetime
from . import io

class Timer:    
    def __enter__(self):
        self.start = datetime.datetime.now()
        return self

    def __exit__(self, *args):
        self.end = datetime.datetime.now()
        diff = self.end - self.start
        diff = diff.seconds + diff.microseconds / 1000000.0
        print("Total time : ", diff)