#include "light_path.h"

MaterialVertex::MaterialVertex(const Intersection &its, Float pdf, EVertex type)
    : type(type), pdf(pdf)
{
    shape_id = its.indices[0];
    triangle_id = its.indices[1];
    barycentric = detach(its.barycentric);
    if (its.isEmitter())
        this->type = EVEmitter;
}

MaterialVertex::MaterialVertex(const DirectSamplingRecord &dRec)
    : type(EVEmitter), pdf(dRec.pdf)
{
    assert(dRec.shape_id >= 0);
    assert(dRec.tri_id >= 0);
    shape_id = dRec.shape_id;
    triangle_id = dRec.tri_id;
    barycentric = dRec.barycentric;
}
