#include "light_path.h"
#include <render/scene.h>

SpatialVertex::SpatialVertex(const Scene &scene, const MaterialVertex &v) : MaterialVertex(v)
{
    if (v.type == EVSensor)
    {
        p = scene.camera.cpos;
    }
    if (v.type & EVSurface)
    {
        const Shape *shape = scene.shape_list[v.shape_id];
        const Vector3i &ind = shape->indices[v.triangle_id];
        const Vector &v0 = shape->getVertex(ind[0]),
                     &v1 = shape->getVertex(ind[1]),
                     &v2 = shape->getVertex(ind[2]);
        p = (1. - v.barycentric.x() - v.barycentric.y()) * v0 +
            v.barycentric.x() * v1 +
            v.barycentric.y() * v2;
        geo_n = shape->getFaceNormal(v.triangle_id);
        sh_n = shape->getShadingNormal(v.triangle_id, v.barycentric);
        geo_frame = Frame(geo_n);
        sh_frame = Frame(sh_n);
        J = shape->getArea(v.triangle_id);
        J /= detach(J);
    }
}

void SpatialVertex::setZero()
{
    p.setZero();
    geo_n.setZero();
    sh_n.setZero();
    J = 0;
    geo_frame.s.setZero();
    geo_frame.t.setZero();
    geo_frame.n.setZero();
    sh_frame.s.setZero();
    sh_frame.t.setZero();
    sh_frame.n.setZero();
}
