#include "light_path.h"

Vertex::Vertex(const Intersection &its, Float pdf, EVertex type)
{
    this->type = type;
    this->pdf = pdf;
    shape_id = its.indices[0];
    triangle_id = its.indices[1];
    int_med_id = its.ptr_shape->med_int_id;
    ext_med_id = its.ptr_shape->med_ext_id;
    
    barycentric = detach(its.barycentric);
    if (its.isEmitter())
        this->type = EVEmitter;
}

Vertex::Vertex(const MediumSamplingRecord &mRec, int med_id, Float pdf)
{
    type = EVVolume;
    this->pdf = pdf;
    medium_id = med_id;
    p = mRec.p;
}
// TODO: handle medium
Vertex::Vertex(const DirectSamplingRecord &dRec)
{
    type = EVEmitter;
    pdf = dRec.pdf;
    assert(dRec.shape_id >= 0);
    assert(dRec.tri_id >= 0);
    shape_id = dRec.shape_id;
    triangle_id = dRec.tri_id;
    barycentric = dRec.barycentric;
}
