#include "null.h"
#include <render/intersection.h>
BSDF *NullBSDF::clone() const
{
    return new NullBSDF(*this);
}

Spectrum NullBSDF::eval(const Intersection &its, const Vector &wo,
                        EBSDFMode mode) const
{
    return Spectrum::Ones();
}

Spectrum NullBSDF::sample(const Intersection &its, const Array3 &rnd,
                          Vector &wo, Float &pdf, Float &eta,
                          EBSDFMode mode) const
{
    wo = -its.wi;
    pdf = 1.0;
    eta = 1.0;
    return Spectrum::Ones();
}

Float NullBSDF::pdf(const Intersection &its, const Vector &wo) const
{
    return 1.0;
}

IMPLEMENT_BSDF_HELPER_FUNCTIONS(NullBSDF)

// namespace
// {
//     __attribute__((optnone)) void __eval(const NullBSDF *bsdf, const Intersection &its, const Vector &wo, EBSDFMode mode, Spectrum &ret) { ret = bsdf->eval(its, wo, mode); }
//     void *__augment_eval(const BSDF *bsdf, BSDF *d_bsdf, const Intersection &its, Intersection &d_its, const Vector &wo, Vector &d_wo, EBSDFMode mode, EBSDFMode d_mode, const Spectrum &ret, Spectrum &d_ret)
//     {
//         // return __enzyme_augmentfwd((void *)__eval, bsdf, d_bsdf, &its, &d_its, &wo, &d_wo, mode, &ret, &d_ret);
//     }
//     void __gradient_eval(const BSDF *bsdf, BSDF *d_bsdf, const Intersection &its, Intersection &d_its, const Vector &wo, Vector &d_wo, EBSDFMode mode, EBSDFMode d_mode, const Spectrum &ret, Spectrum &d_ret, void *tape)
//     {
//         __enzyme_reverse((void *)__eval, enzyme_dup, bsdf, d_bsdf,enzyme_dup,  &its, &d_its, enzyme_dup, &wo, &d_wo, 
//         enzyme_const, mode, enzyme_dup, &ret, &d_ret, tape);
//     }
// }
// void *NullBSDF::__augment_eval(BSDF *d_bsdf, const Intersection &its, Intersection &d_its, const Vector &wo, Vector &d_wo, EBSDFMode mode, EBSDFMode d_mode, const Spectrum &ret, Spectrum &d_ret) const { return ::__augment_eval(this, d_bsdf, its, d_its, wo, d_wo, mode, d_mode, ret, d_ret); }
// void NullBSDF::__gradient_eval(BSDF *d_bsdf, const Intersection &its, Intersection &d_its, const Vector &wo, Vector &d_wo, EBSDFMode mode, EBSDFMode d_mode, const Spectrum &ret, Spectrum &d_ret, void *tape) const { ::__gradient_eval(this, d_bsdf, its, d_its, wo, d_wo, mode, d_mode, ret, d_ret, tape); }
