#pragma once
#include <render/integrator.h>

struct RndSampler;
struct Ray;

struct Path : Integrator
{

    void render(const Scene &scene, const RenderOptions &options,
                ptr<float> rendered_image) const;

    ArrayXd renderC(const Scene &scene, const RenderOptions &options) const;

    ArrayXd renderD(SceneAD &sceneAD,
                    const RenderOptions &options, const ArrayXd &d_image) const;
};